/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class CommandStorage {
    private static final String ID_PREFIX = "command_storage_";
    private final Map<String, Container> namespaces = Maps.newHashMap();
    private final DimensionDataStorage storage;

    public CommandStorage(DimensionDataStorage p_78035_) {
        this.storage = p_78035_;
    }

    private Container newStorage(String p_164836_) {
        Container $$1 = new Container();
        this.namespaces.put(p_164836_, $$1);
        return $$1;
    }

    private SavedData.Factory<Container> factory(String p_296143_) {
        return new SavedData.Factory<Container>(() -> this.newStorage(p_296143_), (p_164844_, p_323732_) -> this.newStorage(p_296143_).load((CompoundTag)p_164844_), DataFixTypes.SAVED_DATA_COMMAND_STORAGE);
    }

    public CompoundTag get(ResourceLocation p_78045_) {
        String $$1 = p_78045_.getNamespace();
        Container $$2 = this.storage.get(this.factory($$1), CommandStorage.createId($$1));
        return $$2 != null ? $$2.get(p_78045_.getPath()) : new CompoundTag();
    }

    public void set(ResourceLocation p_78047_, CompoundTag p_78048_) {
        String $$2 = p_78047_.getNamespace();
        this.storage.computeIfAbsent(this.factory($$2), CommandStorage.createId($$2)).put(p_78047_.getPath(), p_78048_);
    }

    public Stream<ResourceLocation> keys() {
        return this.namespaces.entrySet().stream().flatMap(p_164841_ -> ((Container)p_164841_.getValue()).getKeys((String)p_164841_.getKey()));
    }

    private static String createId(String p_78038_) {
        return ID_PREFIX + p_78038_;
    }

    static class Container
    extends SavedData {
        private static final String TAG_CONTENTS = "contents";
        private final Map<String, CompoundTag> storage = Maps.newHashMap();

        Container() {
        }

        Container load(CompoundTag p_164850_) {
            CompoundTag $$1 = p_164850_.getCompound(TAG_CONTENTS);
            for (String $$2 : $$1.getAllKeys()) {
                this.storage.put($$2, $$1.getCompound($$2));
            }
            return this;
        }

        @Override
        public CompoundTag save(CompoundTag p_78075_, HolderLookup.Provider p_323504_) {
            CompoundTag $$2 = new CompoundTag();
            this.storage.forEach((p_78070_, p_78071_) -> $$2.put((String)p_78070_, p_78071_.copy()));
            p_78075_.put(TAG_CONTENTS, $$2);
            return p_78075_;
        }

        public CompoundTag get(String p_78059_) {
            CompoundTag $$1 = this.storage.get(p_78059_);
            return $$1 != null ? $$1 : new CompoundTag();
        }

        public void put(String p_78064_, CompoundTag p_78065_) {
            if (p_78065_.isEmpty()) {
                this.storage.remove(p_78064_);
            } else {
                this.storage.put(p_78064_, p_78065_);
            }
            this.setDirty();
        }

        public Stream<ResourceLocation> getKeys(String p_78073_) {
            return this.storage.keySet().stream().map(p_350257_ -> ResourceLocation.fromNamespaceAndPath(p_78073_, p_350257_));
        }
    }
}

